#include <amxmodx>
#include <engine>
#include <fakemeta>
#include <fun>
#include <hamsandwich>
#include <xs>
#include <cstrike>
enum
{
	anim_idle,
	anim_reload,
	anim_draw,
	anim_shoot1,
	anim_shoot2,
	anim_shoot3
}

#define ENG_NULLENT		-1
#define EV_INT_WEAPONKEY	EV_INT_impulse
#define SVD_WEAPONKEY	801
#define VSK94_WEAPONKEY		802
#define M24_WEAPONKEY	803
#define M400_WEAPONKEY	804
#define SG1_WEAPONKEY	805
#define MAX_PLAYERS  32
const USE_STOPPED = 0
const OFFSET_ACTIVE_ITEM = 373
const OFFSET_WEAPONOWNER = 41
const OFFSET_LINUX = 5
const OFFSET_LINUX_WEAPONS = 4
#define WEAP_LINUX_XTRA_OFF			4
#define m_fKnown				44
#define m_flNextPrimaryAttack 			46
#define m_flTimeWeaponIdle			48
#define m_iClip					51
#define m_fInReload				54
#define PLAYER_LINUX_XTRA_OFF			5
#define m_flNextAttack				83
#define SVD_RELOAD_TIME 3.8
#define VSK_RELOAD_TIME 3.5

#define PRAVA ADMIN_RESERVATION

const PRIMARY_WEAPONS_BIT_SUM = (1<<CSW_SCOUT)|(1<<CSW_XM1014)|(1<<CSW_MAC10)|(1<<CSW_AUG)|(1<<CSW_UMP45)|(1<<CSW_SG550)|(1<<CSW_GALIL)|(1<<CSW_FAMAS)|(1<<CSW_AWP)|(1<<CSW_MP5NAVY)|(1<<CSW_M249)|(1<<CSW_M3)|(1<<CSW_M4A1)|(1<<CSW_TMP)|(1<<CSW_G3SG1)|(1<<CSW_SG552)|(1<<CSW_AK47)|(1<<CSW_P90)
new const WEAPONENTNAMES[][] = { "", "weapon_p228", "", "weapon_scout", "weapon_hegrenade", "weapon_xm1014", "weapon_c4", "weapon_mac10",
			"weapon_aug", "weapon_smokegrenade", "weapon_elite", "weapon_fiveseven", "weapon_ump45", "weapon_sg550",
			"weapon_galil", "weapon_famas", "weapon_usp", "weapon_glock18", "weapon_awp", "weapon_mp5navy", "weapon_m249",
			"weapon_m3", "weapon_m4a1", "weapon_tmp", "weapon_g3sg1", "weapon_flashbang", "weapon_deagle", "weapon_sg552",
			"weapon_ak47", "weapon_knife", "weapon_p90" }
new const Fire_Sounds[][] = { "weapons/gatling-1.wav", "weapons/gatling-1.wav", "weapons/gatling-1.wav", "weapons/gatling-1.wav" }
new const GUNSHOT_DECALS[] = { 41, 42, 43, 44, 45 }
new SVD_V_MODEL[64] = "models/v_gatling.mdl"
new SVD_P_MODEL[64] = "models/p_gatling.mdl"
new SVD_W_MODEL[64] = "models/w_gatling.mdl"
new VSK94_V_MODEL[64] = "models/v_gatling.mdl"
new VSK94_P_MODEL[64] = "models/p_gatling.mdl"
new VSK94_W_MODEL[64] = "models/w_gatling.mdl"
new M24_V_MODEL[64] = "models/v_gatling.mdl"
new M24_P_MODEL[64] = "models/p_gatling.mdl"
new M24_W_MODEL[64] = "models/w_gatling.mdl"
new M400_V_MODEL[64] = "models/v_gatling.mdl"
new M400_P_MODEL[64] = "models/p_gatling.mdl"
new M400_W_MODEL[64] = "models/w_gatling.mdl"
new cvar_dmg_svd, cvar_recoil_svd, g_itemid_svd, cvar_spd_svd, cvar_ammo_svd
new cvar_dmg_vsk94, cvar_recoil_vsk94, g_itemid_vsk94, cvar_spd_vsk94, cvar_ammo_vsk94
new cvar_dmg_m24, cvar_recoil_m24, g_itemid_m24, cvar_ammo_m24
new cvar_dmg_m400, cvar_recoil_m400, g_itemid_m400, cvar_ammo_m400
new cvar_clip_svd, cvar_clip_vsk94, cvar_clip_m400, cvar_clip_m24
new g_has_svd[33], g_has_vsk94[33], g_has_m24[33], g_has_m400[33]
new g_MaxPlayers, g_orig_event_svd, g_orig_event_sg550, g_orig_event_scout, g_orig_event_awp, g_IsInPrimaryAttack, g_clip_ammo[33], g_svd_TmpClip[33], g_vsk_TmpClip[33]
new Float:cl_pushangle[MAX_PLAYERS + 1][3], m_iBlood[2]

public plugin_init()
{
	register_plugin("VOLCANO ELECTRIC SHOTGUN-MINIGUN", "1.0", "Crock")
	register_message(get_user_msgid("DeathMsg"), "message_DeathMsg")
	register_event("CurWeapon","CurrentWeapon","be","1=1")
	RegisterHam(Ham_Item_AddToPlayer, "weapon_xm1014", "fw_SVD_AddToPlayer")
	RegisterHam(Ham_Use, "func_tank", "fw_UseStationary_Post", 1)
	RegisterHam(Ham_Use, "func_tankmortar", "fw_UseStationary_Post", 1)
	RegisterHam(Ham_Use, "func_tankrocket", "fw_UseStationary_Post", 1)
	RegisterHam(Ham_Use, "func_tanklaser", "fw_UseStationary_Post", 1)
	for (new i = 1; i < sizeof WEAPONENTNAMES; i++)
		if (WEAPONENTNAMES[i][0]) RegisterHam(Ham_Item_Deploy, WEAPONENTNAMES[i], "fw_Item_Deploy_Post", 1)
	RegisterHam(Ham_Weapon_PrimaryAttack, "weapon_xm1014", "fw_SVD_PrimaryAttack")
	RegisterHam(Ham_Weapon_PrimaryAttack, "weapon_xm1014", "fw_SVD_PrimaryAttack_Post", 1)
	RegisterHam(Ham_Item_PostFrame, "weapon_xm1014", "SVD__ItemPostFrame");
	RegisterHam(Ham_Weapon_Reload, "weapon_xm1014", "SVD__Reload");
	RegisterHam(Ham_Weapon_Reload, "weapon_xm1014", "SVD__Reload_Post", 1);
	RegisterHam(Ham_TakeDamage, "player", "fw_TakeDamage")
	register_forward(FM_SetModel, "fw_SetModel")
	register_forward(FM_UpdateClientData, "fw_UpdateClientData_Post", 1)
	register_forward(FM_PlaybackEvent, "fwPlaybackEvent")
	
	cvar_dmg_svd = register_cvar("zp_volcano_dmg", "2.45")
	cvar_recoil_svd = register_cvar("zp_volcano_recoil", "0.9")
	cvar_clip_svd = register_cvar("zp_volcano_clip", "40")
	cvar_ammo_svd = register_cvar("zp_volcano_ammo", "120")
	cvar_spd_svd = register_cvar("zp_volcano_spd", "1.2")
	
	register_clcmd("volcano", "give_volcano");
	g_MaxPlayers = get_maxplayers()
}

public plugin_precache()
{
	precache_model(SVD_V_MODEL)
	precache_model(SVD_P_MODEL)
	precache_model(SVD_W_MODEL)
	for(new i = 0; i < sizeof Fire_Sounds; i++)
		precache_sound(Fire_Sounds[i])
	m_iBlood[0] = precache_model("sprites/blood.spr")
	m_iBlood[1] = precache_model("sprites/bloodspray.spr")
	register_forward(FM_PrecacheEvent, "fwPrecacheEvent_Post", 1)
}

public fwPrecacheEvent_Post(type, const name[])
{
	if (equal("events/xm1014.sc", name))
	{
		g_orig_event_svd = get_orig_retval()
		return FMRES_HANDLED
	}

	return FMRES_IGNORED
}

public client_connect(id)
{
	g_has_svd[id] = false
	g_has_vsk94[id] = false
	g_has_m24[id] = false
	g_has_m400[id] = false
}

public client_disconnect(id)
{
	g_has_svd[id] = false
	g_has_vsk94[id] = false
	g_has_m24[id] = false
	g_has_m400[id] = false
}

public fw_SetModel(entity, model[])
{
	if(!is_valid_ent(entity))
		return FMRES_IGNORED;
	
	static szClassName[33]
	entity_get_string(entity, EV_SZ_classname, szClassName, charsmax(szClassName))
		
	if(!equal(szClassName, "weaponbox"))
		return FMRES_IGNORED;
	
	static iOwner
	
	iOwner = entity_get_edict(entity, EV_ENT_owner)
	
	if(equal(model, "models/w_xm1014.mdl"))
	{
		static iStoredSVDID
		
		iStoredSVDID = find_ent_by_owner(ENG_NULLENT, "weapon_xm1014", entity)
	
		if(!is_valid_ent(iStoredSVDID))
			return FMRES_IGNORED;
	
		if(g_has_svd[iOwner])
		{
			entity_set_int(iStoredSVDID, EV_INT_WEAPONKEY, SVD_WEAPONKEY)
			
			g_has_svd[iOwner] = false
			
			entity_set_model(entity, SVD_W_MODEL)
			
			return FMRES_SUPERCEDE;
		}
	}
	else if(equal(model, "models/w_sg550.mdl"))
	{
		static iStoredSG550ID
		
		iStoredSG550ID = find_ent_by_owner(ENG_NULLENT, "weapon_sg550", entity)
		
		if(!is_valid_ent(iStoredSG550ID))
			return FMRES_IGNORED;
		
		if(g_has_vsk94[iOwner])
		{
			entity_set_int(iStoredSG550ID, EV_INT_WEAPONKEY, VSK94_WEAPONKEY)
			
			g_has_vsk94[iOwner] = false
			
			entity_set_model(entity, VSK94_W_MODEL)
			
			return FMRES_SUPERCEDE;
		}
	}
	else if(equal(model, "models/w_scout.mdl"))
	{
		static iStoredSCOUTID
		
		iStoredSCOUTID = find_ent_by_owner(ENG_NULLENT, "weapon_scout", entity)
		
		if(!is_valid_ent(iStoredSCOUTID))
			return FMRES_IGNORED;
		
		if(g_has_m24[iOwner])
		{
			entity_set_int(iStoredSCOUTID, EV_INT_WEAPONKEY, M24_WEAPONKEY)
			
			g_has_m24[iOwner] = false
			
			entity_set_model(entity, M24_W_MODEL)
			
			return FMRES_SUPERCEDE;
		}
	}
	else if(equal(model, "models/w_awp.mdl"))
	{
		static iStoredAWPID
		
		iStoredAWPID = find_ent_by_owner(ENG_NULLENT, "weapon_awp", entity)
		
		if(!is_valid_ent(iStoredAWPID))
			return FMRES_IGNORED;
		
		if(g_has_m400[iOwner])
		{
			entity_set_int(iStoredAWPID, EV_INT_WEAPONKEY, M400_WEAPONKEY)
			
			g_has_m400[iOwner] = false
			
			entity_set_model(entity, M400_W_MODEL)
			
			return FMRES_SUPERCEDE;
		}
	}
	
	return FMRES_IGNORED;
}

public give_volcano(id, itemid)
{
	if(!(get_user_flags(id) & PRAVA) ) 
		return
	if(itemid == g_itemid_svd)
	{	
		drop_weapons(id, 1);
		new iWep2 = give_item(id,"weapon_xm1014")
		if( iWep2 > 0 )
		{
			cs_set_weapon_ammo( iWep2, get_pcvar_num(cvar_clip_svd) )
			cs_set_user_bpammo (id, CSW_XM1014, get_pcvar_num(cvar_ammo_svd))
		}
		g_has_svd[id] = true;
	}
	else if(itemid == g_itemid_vsk94)
	{	
		drop_weapons(id, 1);
		new iWep3 = give_item(id,"weapon_sg550")
		if( iWep3 > 0 )
		{
			cs_set_weapon_ammo( iWep3, get_pcvar_num(cvar_clip_vsk94) )
			cs_set_user_bpammo (id, CSW_SG550, get_pcvar_num(cvar_ammo_vsk94))
		}
		g_has_vsk94[id] = true;
	}
	else if(itemid == g_itemid_m24)
	{	
		drop_weapons(id, 1);
		new iWep3 = give_item(id,"weapon_scout")
		if( iWep3 > 0 )
		{
			cs_set_weapon_ammo( iWep3, get_pcvar_num(cvar_clip_m24) )
			cs_set_user_bpammo (id, CSW_SCOUT, get_pcvar_num(cvar_ammo_m24))
		}
		g_has_m24[id] = true;
	}
	else if(itemid == g_itemid_m400)
	{
		drop_weapons(id, 1);
		new iWep3 = give_item(id,"weapon_awp")
		if( iWep3 > 0 )
		{
			cs_set_weapon_ammo( iWep3, get_pcvar_num(cvar_clip_m400) )
			cs_set_user_bpammo (id, CSW_AWP, get_pcvar_num(cvar_ammo_m400))
		}
		
		g_has_m400[id] = true;
	}
}

public fw_SVD_AddToPlayer(SVD, id)
{
	if(!is_valid_ent(SVD) || !is_user_connected(id))
		return HAM_IGNORED;
	
	if(entity_get_int(SVD, EV_INT_WEAPONKEY) == SVD_WEAPONKEY)
	{
		g_has_svd[id] = true
		
		entity_set_int(SVD, EV_INT_WEAPONKEY, 0)
		
		return HAM_HANDLED;
	}
	
	return HAM_IGNORED;
}

public fw_SG550_AddToPlayer(SG550, id)
{
	if(!is_valid_ent(SG550) || !is_user_connected(id))
		return HAM_IGNORED;
	
	if(entity_get_int(SG550, EV_INT_WEAPONKEY) == VSK94_WEAPONKEY)
	{
		g_has_vsk94[id] = true
		
		entity_set_int(SG550, EV_INT_WEAPONKEY, 0)
		
		return HAM_HANDLED;
	}
	
	return HAM_IGNORED;
}

public fw_SCOUT_AddToPlayer(SCOUT, id)
{
	if(!is_valid_ent(SCOUT) || !is_user_connected(id))
		return HAM_IGNORED;
	
	if(entity_get_int(SCOUT, EV_INT_WEAPONKEY) == M24_WEAPONKEY)
	{
		g_has_m24[id] = true
		
		entity_set_int(SCOUT, EV_INT_WEAPONKEY, 0)
		
		return HAM_HANDLED;
	}
	
	return HAM_IGNORED;
}

public fw_AWP_AddToPlayer(AWP, id)
{
	if(!is_valid_ent(AWP) || !is_user_connected(id))
		return HAM_IGNORED;
	
	if(entity_get_int(AWP, EV_INT_WEAPONKEY) == M400_WEAPONKEY)
	{
		g_has_m400[id] = true
		
		entity_set_int(AWP, EV_INT_WEAPONKEY, 0)
		
		return HAM_HANDLED;
	}
	
	return HAM_IGNORED;
}

public fw_UseStationary_Post(entity, caller, activator, use_type)
{
	if (use_type == USE_STOPPED && is_user_connected(caller))
		replace_weapon_models(caller, get_user_weapon(caller))
}

public fw_Item_Deploy_Post(weapon_ent)
{
	static owner
	owner = fm_cs_get_weapon_ent_owner(weapon_ent)
	
	static weaponid
	weaponid = cs_get_weapon_id(weapon_ent)
	
	replace_weapon_models(owner, weaponid)
}

public CurrentWeapon(id)
{
     replace_weapon_models(id, read_data(2))

     if((read_data(2) != CSW_XM1014 || !g_has_svd[id]) && (read_data(2) != CSW_SG550 || !g_has_vsk94[id]))
          return
     
     static Float:iSpeed
     if(g_has_svd[id])
          iSpeed = get_pcvar_float(cvar_spd_svd)
     else if(g_has_vsk94[id])
          iSpeed = get_pcvar_float(cvar_spd_vsk94)
     
     static weapon[32],Ent
     get_weaponname(read_data(2),weapon,31)
     Ent = find_ent_by_owner(-1,weapon,id)
     if(Ent)
     {
          static Float:Delay, Float:M_Delay
          Delay = get_pdata_float( Ent, 46, 4) * iSpeed
          M_Delay = get_pdata_float( Ent, 47, 4) * iSpeed
          if (Delay > 0.0)
          {
               set_pdata_float(Ent, 46, Delay, 4)
               set_pdata_float(Ent, 47, M_Delay, 4)
          }
     }
}

replace_weapon_models(id, weaponid)
{
	switch (weaponid)
	{
		case CSW_XM1014:
		{
			
			if(g_has_svd[id])
			{
				set_pev(id, pev_viewmodel2, SVD_V_MODEL)
				set_pev(id, pev_weaponmodel2, SVD_P_MODEL)
			}
		}
		case CSW_SG550:
		{
			
			if(g_has_vsk94[id])
			{
				set_pev(id, pev_viewmodel2, VSK94_V_MODEL)
				set_pev(id, pev_weaponmodel2, VSK94_P_MODEL)
			}
		}
		case CSW_SCOUT:
		{
			
			if(g_has_m24[id])
			{
				set_pev(id, pev_viewmodel2, M24_V_MODEL)
				set_pev(id, pev_weaponmodel2, M24_P_MODEL)
			}
		}
		case CSW_AWP:
		{
			
			if(g_has_m400[id])
			{
				set_pev(id, pev_viewmodel2, M400_V_MODEL)
				set_pev(id, pev_weaponmodel2, M400_P_MODEL)
			}
		}
	}
}

public fw_UpdateClientData_Post(Player, SendWeapons, CD_Handle)
{
	if(!is_user_alive(Player) || (get_user_weapon(Player) != CSW_XM1014 && get_user_weapon(Player) != CSW_SG550 && get_user_weapon(Player) != CSW_SCOUT && get_user_weapon(Player) != CSW_AWP) || 
        (get_user_weapon(Player) == CSW_XM1014 && !g_has_svd[Player]) || (get_user_weapon(Player) == CSW_SG550 && !g_has_vsk94[Player]) || (get_user_weapon(Player) == CSW_SCOUT && !g_has_m24[Player]) || (get_user_weapon(Player) == CSW_AWP && !g_has_m400[Player]))
		return FMRES_IGNORED
	
	set_cd(CD_Handle, CD_flNextAttack, halflife_time () + 0.001)
	return FMRES_HANDLED
}

public fw_SVD_PrimaryAttack(Weapon)
{
	new Player = get_pdata_cbase(Weapon, 41, 5)
	
	if (!g_has_svd[Player])
		return;
	
	g_IsInPrimaryAttack = 1
	pev(Player,pev_punchangle,cl_pushangle[Player])
	
	g_clip_ammo[Player] = cs_get_weapon_ammo(Weapon)
}

public fw_SG550_PrimaryAttack(Weapon)
{
	new Player = get_pdata_cbase(Weapon, 41, 5)
	
	if (!g_has_vsk94[Player])
		return;
	
	g_IsInPrimaryAttack = 1
	pev(Player,pev_punchangle,cl_pushangle[Player])
	
	g_clip_ammo[Player] = cs_get_weapon_ammo(Weapon)
}

public fw_SCOUT_PrimaryAttack(Weapon)
{
	new Player = get_pdata_cbase(Weapon, 41, 5)
	
	if (!g_has_m24[Player])
		return;
	
	g_IsInPrimaryAttack = 1
	pev(Player,pev_punchangle,cl_pushangle[Player])
	
	g_clip_ammo[Player] = cs_get_weapon_ammo(Weapon)
}

public fw_AWP_PrimaryAttack(Weapon)
{
	new Player = get_pdata_cbase(Weapon, 41, 5)
	
	if (!g_has_m400[Player])
		return;
	
	g_IsInPrimaryAttack = 1
	pev(Player,pev_punchangle,cl_pushangle[Player])
	
	g_clip_ammo[Player] = cs_get_weapon_ammo(Weapon)
}

public fwPlaybackEvent(flags, invoker, eventid, Float:delay, Float:origin[3], Float:angles[3], Float:fparam1, Float:fparam2, iParam1, iParam2, bParam1, bParam2)
{
	if ((eventid != g_orig_event_svd && eventid != g_orig_event_sg550 && eventid != g_orig_event_scout && eventid != g_orig_event_awp) || !g_IsInPrimaryAttack)
		return FMRES_IGNORED
	if (!(1 <= invoker <= g_MaxPlayers))
		return FMRES_IGNORED

	playback_event(flags | FEV_HOSTONLY, invoker, eventid, delay, origin, angles, fparam1, fparam2, iParam1, iParam2, bParam1, bParam2)
	return FMRES_SUPERCEDE
}

public fw_SVD_PrimaryAttack_Post(Weapon)
{
	g_IsInPrimaryAttack = 0
	new Player = get_pdata_cbase(Weapon, 41, 5)
	
	if(g_has_svd[Player])
	{
		new Float:push[3]
		pev(Player,pev_punchangle,push)
		xs_vec_sub(push,cl_pushangle[Player],push)
		
		xs_vec_mul_scalar(push,get_pcvar_float(cvar_recoil_svd),push)
		xs_vec_add(push,cl_pushangle[Player],push)
		set_pev(Player,pev_punchangle,push)
		
		if (!g_clip_ammo[Player])
			return
		
		emit_sound(Player, CHAN_WEAPON, Fire_Sounds[0], VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
		UTIL_PlayWeaponAnimation(Player, anim_reload)
	
		make_blood_and_bulletholes(Player)
	}
}

public fw_SG550_PrimaryAttack_Post(Weapon)
{
	g_IsInPrimaryAttack = 0
	new Player = get_pdata_cbase(Weapon, 41, 5)
	
	if(g_has_vsk94[Player])
	{
		new Float:push[3]
		pev(Player,pev_punchangle,push)
		xs_vec_sub(push,cl_pushangle[Player],push)
		
		xs_vec_mul_scalar(push,get_pcvar_float(cvar_recoil_vsk94),push)
		xs_vec_add(push,cl_pushangle[Player],push)
		set_pev(Player,pev_punchangle,push)
		
		if (!g_clip_ammo[Player])
			return
		
		emit_sound(Player, CHAN_WEAPON, Fire_Sounds[1], VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
		UTIL_PlayWeaponAnimation(Player, anim_reload)
	
		make_blood_and_bulletholes(Player)
	}
}

public fw_SCOUT_PrimaryAttack_Post(Weapon)
{
	g_IsInPrimaryAttack = 0
	new Player = get_pdata_cbase(Weapon, 41, 5)
	
	if(g_has_m24[Player])
	{
		new Float:push[3]
		pev(Player,pev_punchangle,push)
		xs_vec_sub(push,cl_pushangle[Player],push)
		
		xs_vec_mul_scalar(push,get_pcvar_float(cvar_recoil_m24),push)
		xs_vec_add(push,cl_pushangle[Player],push)
		set_pev(Player,pev_punchangle,push)
		
		if (!g_clip_ammo[Player])
			return
		
		emit_sound(Player, CHAN_WEAPON, Fire_Sounds[2], VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
		UTIL_PlayWeaponAnimation(Player, anim_reload)
	
		make_blood_and_bulletholes(Player)
	}
}

public fw_AWP_PrimaryAttack_Post(Weapon)
{
	g_IsInPrimaryAttack = 0
	new Player = get_pdata_cbase(Weapon, 41, 5)
	
	if(g_has_m400[Player])
	{
		new Float:push[3]
		pev(Player,pev_punchangle,push)
		xs_vec_sub(push,cl_pushangle[Player],push)
		
		xs_vec_mul_scalar(push,get_pcvar_float(cvar_recoil_m400),push)
		xs_vec_add(push,cl_pushangle[Player],push)
		set_pev(Player,pev_punchangle,push)
		
		if (!g_clip_ammo[Player])
			return
		
		emit_sound(Player, CHAN_WEAPON, Fire_Sounds[3], VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
		UTIL_PlayWeaponAnimation(Player, anim_reload)
	
		make_blood_and_bulletholes(Player)
	}
}

public SVD__ItemPostFrame(weapon_entity) {
	new id = pev(weapon_entity, pev_owner)
	if (!is_user_connected(id))
		return HAM_IGNORED;

	if (!g_has_svd[id])
		return HAM_IGNORED;

	new Float:flNextAttack = get_pdata_float(id, m_flNextAttack, PLAYER_LINUX_XTRA_OFF)

	new iBpAmmo = cs_get_user_bpammo(id, CSW_XM1014);
	new iClip = get_pdata_int(weapon_entity, m_iClip, WEAP_LINUX_XTRA_OFF)

	new fInReload = get_pdata_int(weapon_entity, m_fInReload, WEAP_LINUX_XTRA_OFF) 

	if( fInReload && flNextAttack <= 0.0 )
	{
		new j = min(get_pcvar_num(cvar_clip_svd) - iClip, iBpAmmo)
	
		set_pdata_int(weapon_entity, m_iClip, iClip + j, WEAP_LINUX_XTRA_OFF)
		cs_set_user_bpammo(id, CSW_XM1014, iBpAmmo-j);
		
		set_pdata_int(weapon_entity, m_fInReload, 0, WEAP_LINUX_XTRA_OFF)
		fInReload = 0
	}

	return HAM_IGNORED;
}

public SVD__Reload(weapon_entity) {
	new id = pev(weapon_entity, pev_owner)
	if (!is_user_connected(id))
		return HAM_IGNORED;

	if (!g_has_svd[id])
		return HAM_IGNORED;

	g_svd_TmpClip[id] = -1;

	new iBpAmmo = cs_get_user_bpammo(id, CSW_XM1014);
	new iClip = get_pdata_int(weapon_entity, m_iClip, WEAP_LINUX_XTRA_OFF)

	if (iBpAmmo <= 0)
		return HAM_SUPERCEDE;

	if (iClip >= get_pcvar_num(cvar_clip_svd))
		return HAM_SUPERCEDE;


	g_svd_TmpClip[id] = iClip;

	return HAM_IGNORED;
}

public SVD__Reload_Post(weapon_entity) {
	new id = pev(weapon_entity, pev_owner)
	if (!is_user_connected(id))
		return HAM_IGNORED;

	if (!g_has_svd[id])
		return HAM_IGNORED;

	if (g_svd_TmpClip[id] == -1)
		return HAM_IGNORED;

	set_pdata_int(weapon_entity, m_iClip, g_svd_TmpClip[id], WEAP_LINUX_XTRA_OFF)

	set_pdata_float(weapon_entity, m_flTimeWeaponIdle, SVD_RELOAD_TIME, WEAP_LINUX_XTRA_OFF)

	set_pdata_float(id, m_flNextAttack, SVD_RELOAD_TIME, PLAYER_LINUX_XTRA_OFF)

	set_pdata_int(weapon_entity, m_fInReload, 1, WEAP_LINUX_XTRA_OFF)

	// relaod animation
	UTIL_PlayWeaponAnimation(id, 3)

	return HAM_IGNORED;
}

public SG550__ItemPostFrame(weapon_entity) {
	new id = pev(weapon_entity, pev_owner)
	if (!is_user_connected(id))
		return HAM_IGNORED;

	if (!g_has_vsk94[id])
		return HAM_IGNORED;

	new Float:flNextAttack = get_pdata_float(id, m_flNextAttack, PLAYER_LINUX_XTRA_OFF)

	new iBpAmmo = cs_get_user_bpammo(id, CSW_SG550);
	new iClip = get_pdata_int(weapon_entity, m_iClip, WEAP_LINUX_XTRA_OFF)

	new fInReload = get_pdata_int(weapon_entity, m_fInReload, WEAP_LINUX_XTRA_OFF) 

	if( fInReload && flNextAttack <= 0.0 )
	{
		new j = min(get_pcvar_num(cvar_clip_vsk94) - iClip, iBpAmmo)
	
		set_pdata_int(weapon_entity, m_iClip, iClip + j, WEAP_LINUX_XTRA_OFF)
		cs_set_user_bpammo(id, CSW_SG550, iBpAmmo-j);
		
		set_pdata_int(weapon_entity, m_fInReload, 0, WEAP_LINUX_XTRA_OFF)
		fInReload = 0
	}

	return HAM_IGNORED;
}

public SG550__Reload(weapon_entity) {
	new id = pev(weapon_entity, pev_owner)
	if (!is_user_connected(id))
		return HAM_IGNORED;

	if (!g_has_vsk94[id])
		return HAM_IGNORED;

	g_vsk_TmpClip[id] = -1;

	new iBpAmmo = cs_get_user_bpammo(id, CSW_SG550);
	new iClip = get_pdata_int(weapon_entity, m_iClip, WEAP_LINUX_XTRA_OFF)

	if (iBpAmmo <= 0)
		return HAM_SUPERCEDE;

	if (iClip >= get_pcvar_num(cvar_clip_vsk94))
		return HAM_SUPERCEDE;


	g_vsk_TmpClip[id] = iClip;

	return HAM_IGNORED;
}

public SG550__Reload_Post(weapon_entity) {
	new id = pev(weapon_entity, pev_owner)
	if (!is_user_connected(id))
		return HAM_IGNORED;

	if (!g_has_vsk94[id])
		return HAM_IGNORED;

	if (g_vsk_TmpClip[id] == -1)
		return HAM_IGNORED;

	set_pdata_int(weapon_entity, m_iClip, g_vsk_TmpClip[id], WEAP_LINUX_XTRA_OFF)

	set_pdata_float(weapon_entity, m_flTimeWeaponIdle, VSK_RELOAD_TIME, WEAP_LINUX_XTRA_OFF)

	set_pdata_float(id, m_flNextAttack, VSK_RELOAD_TIME, PLAYER_LINUX_XTRA_OFF)

	set_pdata_int(weapon_entity, m_fInReload, 1, WEAP_LINUX_XTRA_OFF)

	// relaod animation
	UTIL_PlayWeaponAnimation(id, 3)

	return HAM_IGNORED;
}

public fw_TakeDamage(victim, inflictor, attacker, Float:damage)
{
	if (victim != attacker && is_user_connected(attacker))
	{
		if(get_user_weapon(attacker) == CSW_XM1014)
		{
			if(g_has_svd[attacker])
				SetHamParamFloat(4, damage * get_pcvar_float(cvar_dmg_svd))
		}
		else if(get_user_weapon(attacker) == CSW_SG550)
		{
			if(g_has_vsk94[attacker])
				SetHamParamFloat(4, damage * get_pcvar_float(cvar_dmg_vsk94))
		}
		else if(get_user_weapon(attacker) == CSW_SCOUT)
		{
			if(g_has_m24[attacker])
				SetHamParamFloat(4, damage * get_pcvar_float(cvar_dmg_m24))
		}
		else if(get_user_weapon(attacker) == CSW_AWP)
		{
			if(g_has_m400[attacker])
				SetHamParamFloat(4, damage * get_pcvar_float(cvar_dmg_m400))
		}
	}
}

public message_DeathMsg(msg_id, msg_dest, id)
{
	static szTruncatedWeapon[33], iAttacker, iVictim
	
	get_msg_arg_string(4, szTruncatedWeapon, charsmax(szTruncatedWeapon))
	
	iAttacker = get_msg_arg_int(1)
	iVictim = get_msg_arg_int(2)
	
	if(!is_user_connected(iAttacker) || iAttacker == iVictim)
		return PLUGIN_CONTINUE
	
	if(equal(szTruncatedWeapon, "XM1014") && get_user_weapon(iAttacker) == CSW_XM1014)
	{
		if(g_has_svd[iAttacker])
			set_msg_arg_string(4, "svd")
	}
	else if(equal(szTruncatedWeapon, "sg550") && get_user_weapon(iAttacker) == CSW_SG550)
	{
		if(g_has_vsk94[iAttacker])
			set_msg_arg_string(4, "vsk94")
	}
	else if(equal(szTruncatedWeapon, "scout") && get_user_weapon(iAttacker) == CSW_SCOUT)
	{
		if(g_has_m24[iAttacker])
			set_msg_arg_string(4, "m24")
	}
	else if(equal(szTruncatedWeapon, "awp") && get_user_weapon(iAttacker) == CSW_AWP)
	{
		if(g_has_m400[iAttacker])
			set_msg_arg_string(4, "m400")
	}
	
	return PLUGIN_CONTINUE
}

stock fm_cs_get_current_weapon_ent(id)
{
	return get_pdata_cbase(id, OFFSET_ACTIVE_ITEM, OFFSET_LINUX);
}

stock fm_cs_get_weapon_ent_owner(ent)
{
	return get_pdata_cbase(ent, OFFSET_WEAPONOWNER, OFFSET_LINUX_WEAPONS);
}

stock UTIL_PlayWeaponAnimation(const Player, const Sequence)
{
	set_pev(Player, pev_weaponanim, Sequence)
	
	message_begin(MSG_ONE_UNRELIABLE, SVC_WEAPONANIM, .player = Player)
	write_byte(Sequence)
	write_byte(pev(Player, pev_body))
	message_end()
}

stock make_blood_and_bulletholes(id)
{
	new aimOrigin[3], target, body
	get_user_origin(id, aimOrigin, 3)
	get_user_aiming(id, target, body)
	
	if(target > 0 && target <= g_MaxPlayers)
	{
		new Float:fStart[3], Float:fEnd[3], Float:fRes[3], Float:fVel[3]
		pev(id, pev_origin, fStart)
		
		velocity_by_aim(id, 64, fVel)
		
		fStart[0] = float(aimOrigin[0])
		fStart[1] = float(aimOrigin[1])
		fStart[2] = float(aimOrigin[2])
		fEnd[0] = fStart[0]+fVel[0]
		fEnd[1] = fStart[1]+fVel[1]
		fEnd[2] = fStart[2]+fVel[2]
		
		new res
		engfunc(EngFunc_TraceLine, fStart, fEnd, 0, target, res)
		get_tr2(res, TR_vecEndPos, fRes)
		
		message_begin(MSG_BROADCAST, SVC_TEMPENTITY) 
		write_byte(TE_BLOODSPRITE)
		write_coord(floatround(fStart[0])) 
		write_coord(floatround(fStart[1])) 
		write_coord(floatround(fStart[2])) 
		write_short( m_iBlood [ 1 ])
		write_short( m_iBlood [ 0 ] )
		write_byte(70)
		write_byte(random_num(1,2))
		message_end()
		
		
	} 
	else if(!is_user_connected(target))
	{
		if(target)
		{
			message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
			write_byte(TE_DECAL)
			write_coord(aimOrigin[0])
			write_coord(aimOrigin[1])
			write_coord(aimOrigin[2])
			write_byte(GUNSHOT_DECALS[random_num ( 0, sizeof GUNSHOT_DECALS -1 ) ] )
			write_short(target)
			message_end()
		} 
		else 
		{
			message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
			write_byte(TE_WORLDDECAL)
			write_coord(aimOrigin[0])
			write_coord(aimOrigin[1])
			write_coord(aimOrigin[2])
			write_byte(GUNSHOT_DECALS[random_num ( 0, sizeof GUNSHOT_DECALS -1 ) ] )
			message_end()
		}
		
		message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
		write_byte(TE_GUNSHOTDECAL)
		write_coord(aimOrigin[0])
		write_coord(aimOrigin[1])
		write_coord(aimOrigin[2])
		write_short(id)
		write_byte(GUNSHOT_DECALS[random_num ( 0, sizeof GUNSHOT_DECALS -1 ) ] )
		message_end()
	}
}

stock drop_weapons(id, dropwhat)
{
     static weapons[32], num, i, weaponid
     num = 0
     get_user_weapons(id, weapons, num)
     
     for (i = 0; i < num; i++)
     {
          weaponid = weapons[i]
          
          if (dropwhat == 1 && ((1<<weaponid) & PRIMARY_WEAPONS_BIT_SUM))
          {
               static wname[32]
               get_weaponname(weaponid, wname, sizeof wname - 1)
               engclient_cmd(id, "drop", wname)
          }
     }
}